/*
 * SPDX-License-Identifier: ODbL-1.0
 * SPDX-FileCopyrightText: OpenStreetMap contributors
 *
 * Autogenerated using QGIS - do not edit!
 */

#include "isocodes_p.h"
#include "mapentry_p.h"
#include "timezone_names_p.h"

static constexpr const MapEntry<uint32_t> subdivision_timezone_map[] = {
    {IsoCodes::subdivisionCodeToKey("AU-ACT"), Tz::Australia_Sydney},
    {IsoCodes::subdivisionCodeToKey("AU-NSW"), Tz::Australia_Sydney},
    {IsoCodes::subdivisionCodeToKey("AU-NSW"), Tz::Australia_Broken_Hill},
    {IsoCodes::subdivisionCodeToKey("AU-NSW"), Tz::Australia_Lord_Howe},
    {IsoCodes::subdivisionCodeToKey("AU-NT"), Tz::Australia_Darwin},
    {IsoCodes::subdivisionCodeToKey("AU-QLD"), Tz::Australia_Brisbane},
    {IsoCodes::subdivisionCodeToKey("AU-QLD"), Tz::Australia_Lindeman},
    {IsoCodes::subdivisionCodeToKey("AU-SA"), Tz::Australia_Adelaide},
    {IsoCodes::subdivisionCodeToKey("AU-TAS"), Tz::Australia_Hobart},
    {IsoCodes::subdivisionCodeToKey("AU-TAS"), Tz::Australia_Currie},
    {IsoCodes::subdivisionCodeToKey("AU-TAS"), Tz::Antarctica_Macquarie},
    {IsoCodes::subdivisionCodeToKey("AU-VIC"), Tz::Australia_Melbourne},
    {IsoCodes::subdivisionCodeToKey("AU-WA"), Tz::Australia_Perth},
    {IsoCodes::subdivisionCodeToKey("AU-WA"), Tz::Australia_Eucla},
    {IsoCodes::subdivisionCodeToKey("BR-AC"), Tz::America_Rio_Branco},
    {IsoCodes::subdivisionCodeToKey("BR-AL"), Tz::America_Maceio},
    {IsoCodes::subdivisionCodeToKey("BR-AM"), Tz::America_Manaus},
    {IsoCodes::subdivisionCodeToKey("BR-AM"), Tz::America_Eirunepe},
    {IsoCodes::subdivisionCodeToKey("BR-AP"), Tz::America_Belem},
    {IsoCodes::subdivisionCodeToKey("BR-BA"), Tz::America_Bahia},
    {IsoCodes::subdivisionCodeToKey("BR-DF"), Tz::America_Sao_Paulo},
    {IsoCodes::subdivisionCodeToKey("BR-ES"), Tz::America_Sao_Paulo},
    {IsoCodes::subdivisionCodeToKey("BR-GO"), Tz::America_Sao_Paulo},
    {IsoCodes::subdivisionCodeToKey("BR-MA"), Tz::America_Fortaleza},
    {IsoCodes::subdivisionCodeToKey("BR-MG"), Tz::America_Sao_Paulo},
    {IsoCodes::subdivisionCodeToKey("BR-MS"), Tz::America_Campo_Grande},
    {IsoCodes::subdivisionCodeToKey("BR-MT"), Tz::America_Cuiaba},
    {IsoCodes::subdivisionCodeToKey("BR-PA"), Tz::America_Santarem},
    {IsoCodes::subdivisionCodeToKey("BR-PA"), Tz::America_Belem},
    {IsoCodes::subdivisionCodeToKey("BR-PB"), Tz::America_Fortaleza},
    {IsoCodes::subdivisionCodeToKey("BR-PE"), Tz::America_Recife},
    {IsoCodes::subdivisionCodeToKey("BR-PE"), Tz::America_Noronha},
    {IsoCodes::subdivisionCodeToKey("BR-PI"), Tz::America_Fortaleza},
    {IsoCodes::subdivisionCodeToKey("BR-RJ"), Tz::America_Sao_Paulo},
    // BR-RN
    {IsoCodes::subdivisionCodeToKey("BR-RO"), Tz::America_Porto_Velho},
    {IsoCodes::subdivisionCodeToKey("BR-RR"), Tz::America_Boa_Vista},
    {IsoCodes::subdivisionCodeToKey("BR-RS"), Tz::America_Sao_Paulo},
    {IsoCodes::subdivisionCodeToKey("BR-SE"), Tz::America_Maceio},
    {IsoCodes::subdivisionCodeToKey("BR-SP"), Tz::America_Sao_Paulo},
    {IsoCodes::subdivisionCodeToKey("BR-TO"), Tz::America_Araguaina},
    {IsoCodes::subdivisionCodeToKey("CA-AB"), Tz::America_Edmonton},
    {IsoCodes::subdivisionCodeToKey("CA-BC"), Tz::America_Vancouver},
    {IsoCodes::subdivisionCodeToKey("CA-BC"), Tz::America_Fort_Nelson},
    {IsoCodes::subdivisionCodeToKey("CA-BC"), Tz::America_Dawson_Creek},
    {IsoCodes::subdivisionCodeToKey("CA-BC"), Tz::America_Edmonton},
    {IsoCodes::subdivisionCodeToKey("CA-BC"), Tz::America_Creston},
    {IsoCodes::subdivisionCodeToKey("CA-MB"), Tz::America_Winnipeg},
    {IsoCodes::subdivisionCodeToKey("CA-NB"), Tz::America_Moncton},
    {IsoCodes::subdivisionCodeToKey("CA-NL"), Tz::America_Goose_Bay},
    {IsoCodes::subdivisionCodeToKey("CA-NL"), Tz::America_St_Johns},
    {IsoCodes::subdivisionCodeToKey("CA-NS"), Tz::America_Halifax},
    {IsoCodes::subdivisionCodeToKey("CA-NS"), Tz::America_Glace_Bay},
    {IsoCodes::subdivisionCodeToKey("CA-NT"), Tz::America_Yellowknife},
    {IsoCodes::subdivisionCodeToKey("CA-NT"), Tz::America_Inuvik},
    {IsoCodes::subdivisionCodeToKey("CA-NU"), Tz::America_Iqaluit},
    {IsoCodes::subdivisionCodeToKey("CA-NU"), Tz::America_Rankin_Inlet},
    {IsoCodes::subdivisionCodeToKey("CA-NU"), Tz::America_Cambridge_Bay},
    {IsoCodes::subdivisionCodeToKey("CA-NU"), Tz::America_Pangnirtung},
    {IsoCodes::subdivisionCodeToKey("CA-NU"), Tz::America_Atikokan},
    {IsoCodes::subdivisionCodeToKey("CA-NU"), Tz::America_Resolute},
    {IsoCodes::subdivisionCodeToKey("CA-ON"), Tz::America_Toronto},
    {IsoCodes::subdivisionCodeToKey("CA-ON"), Tz::America_Rainy_River},
    {IsoCodes::subdivisionCodeToKey("CA-ON"), Tz::America_Atikokan},
    {IsoCodes::subdivisionCodeToKey("CA-ON"), Tz::America_Thunder_Bay},
    {IsoCodes::subdivisionCodeToKey("CA-PE"), Tz::America_Halifax},
    {IsoCodes::subdivisionCodeToKey("CA-QC"), Tz::America_Toronto},
    {IsoCodes::subdivisionCodeToKey("CA-QC"), Tz::America_Blanc_Sablon},
    {IsoCodes::subdivisionCodeToKey("CA-QC"), Tz::America_Halifax},
    {IsoCodes::subdivisionCodeToKey("CA-SK"), Tz::America_Regina},
    {IsoCodes::subdivisionCodeToKey("CA-SK"), Tz::America_Swift_Current},
    {IsoCodes::subdivisionCodeToKey("CA-YT"), Tz::America_Whitehorse},
    {IsoCodes::subdivisionCodeToKey("CA-YT"), Tz::America_Dawson},
    {IsoCodes::subdivisionCodeToKey("CD-BC"), Tz::Africa_Kinshasa},
    {IsoCodes::subdivisionCodeToKey("CD-BU"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-EQ"), Tz::Africa_Kinshasa},
    {IsoCodes::subdivisionCodeToKey("CD-HK"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-HL"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-HU"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-IT"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-KC"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-KE"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-KG"), Tz::Africa_Kinshasa},
    {IsoCodes::subdivisionCodeToKey("CD-KL"), Tz::Africa_Kinshasa},
    {IsoCodes::subdivisionCodeToKey("CD-KN"), Tz::Africa_Kinshasa},
    {IsoCodes::subdivisionCodeToKey("CD-KS"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-LO"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-LU"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-MA"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-MN"), Tz::Africa_Kinshasa},
    {IsoCodes::subdivisionCodeToKey("CD-MO"), Tz::Africa_Kinshasa},
    {IsoCodes::subdivisionCodeToKey("CD-NK"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-NU"), Tz::Africa_Kinshasa},
    {IsoCodes::subdivisionCodeToKey("CD-SA"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-SK"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-SU"), Tz::Africa_Kinshasa},
    {IsoCodes::subdivisionCodeToKey("CD-TA"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-TO"), Tz::Africa_Lubumbashi},
    {IsoCodes::subdivisionCodeToKey("CD-TU"), Tz::Africa_Kinshasa},
    {IsoCodes::subdivisionCodeToKey("CL-AI"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-AN"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-AP"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-AR"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-AT"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-BI"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-CO"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-LI"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-LL"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-LR"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-MA"), Tz::America_Punta_Arenas},
    {IsoCodes::subdivisionCodeToKey("CL-ML"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-NB"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-RM"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-TA"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-VS"), Tz::America_Santiago},
    {IsoCodes::subdivisionCodeToKey("CL-VS"), Tz::Pacific_Easter},
    {IsoCodes::subdivisionCodeToKey("CN-AH"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-BJ"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-CQ"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-FJ"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-GD"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-GS"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-GX"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-GZ"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-HA"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-HB"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-HE"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-HI"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-HK"), Tz::Asia_Hong_Kong},
    {IsoCodes::subdivisionCodeToKey("CN-HL"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-HN"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-JL"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-JS"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-JX"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-LN"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-MO"), Tz::Asia_Macau},
    {IsoCodes::subdivisionCodeToKey("CN-NM"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-NX"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-QH"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-SC"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-SD"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-SH"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-SN"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-SX"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-TJ"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-XJ"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-XJ"), Tz::Asia_Urumqi},
    {IsoCodes::subdivisionCodeToKey("CN-XZ"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-XZ"), Tz::Asia_Thimphu},
    {IsoCodes::subdivisionCodeToKey("CN-YN"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("CN-ZJ"), Tz::Asia_Shanghai},
    {IsoCodes::subdivisionCodeToKey("EC-A"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-B"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-C"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-D"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-E"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-F"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-G"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-H"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-I"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-L"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-M"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-N"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-O"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-P"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-R"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-S"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-SD"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-SE"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-T"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-U"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-W"), Tz::Pacific_Galapagos},
    {IsoCodes::subdivisionCodeToKey("EC-X"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-Y"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("EC-Z"), Tz::America_Guayaquil},
    {IsoCodes::subdivisionCodeToKey("ES-AN"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-AR"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-AS"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-CB"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-CE"), Tz::Africa_Ceuta},
    {IsoCodes::subdivisionCodeToKey("ES-CL"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-CM"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-CN"), Tz::Atlantic_Canary},
    {IsoCodes::subdivisionCodeToKey("ES-CT"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-EX"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-GA"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-IB"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-MC"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-MD"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-ML"), Tz::Africa_Ceuta},
    {IsoCodes::subdivisionCodeToKey("ES-NC"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-PV"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-RI"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("ES-VC"), Tz::Europe_Madrid},
    {IsoCodes::subdivisionCodeToKey("FM-KSA"), Tz::Pacific_Kosrae},
    {IsoCodes::subdivisionCodeToKey("FM-PNI"), Tz::Pacific_Pohnpei},
    {IsoCodes::subdivisionCodeToKey("FM-TRK"), Tz::Pacific_Chuuk},
    {IsoCodes::subdivisionCodeToKey("FM-YAP"), Tz::Pacific_Chuuk},
    {IsoCodes::subdivisionCodeToKey("FR-ARA"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-BFC"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-BL"), Tz::America_St_Barthelemy},
    {IsoCodes::subdivisionCodeToKey("FR-BRE"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-COR"), Tz::Europe_Paris},
    // FR-CP
    {IsoCodes::subdivisionCodeToKey("FR-CVL"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-GES"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-GF"), Tz::America_Cayenne},
    {IsoCodes::subdivisionCodeToKey("FR-GUA"), Tz::America_Guadeloupe},
    {IsoCodes::subdivisionCodeToKey("FR-HDF"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-IDF"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-LRE"), Tz::Indian_Reunion},
    {IsoCodes::subdivisionCodeToKey("FR-MAY"), Tz::Indian_Mayotte},
    {IsoCodes::subdivisionCodeToKey("FR-MF"), Tz::America_Marigot},
    {IsoCodes::subdivisionCodeToKey("FR-MQ"), Tz::America_Martinique},
    {IsoCodes::subdivisionCodeToKey("FR-NAQ"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-NC"), Tz::Pacific_Noumea},
    {IsoCodes::subdivisionCodeToKey("FR-NOR"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-OCC"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-PAC"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-PDL"), Tz::Europe_Paris},
    {IsoCodes::subdivisionCodeToKey("FR-PF"), Tz::Pacific_Tahiti},
    {IsoCodes::subdivisionCodeToKey("FR-PF"), Tz::Pacific_Marquesas},
    {IsoCodes::subdivisionCodeToKey("FR-PF"), Tz::Pacific_Gambier},
    {IsoCodes::subdivisionCodeToKey("FR-PM"), Tz::America_Miquelon},
    {IsoCodes::subdivisionCodeToKey("FR-TF"), Tz::Indian_Kerguelen},
    {IsoCodes::subdivisionCodeToKey("FR-WF"), Tz::Pacific_Wallis},
    {IsoCodes::subdivisionCodeToKey("GE-AB"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GE-AB"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("GE-AJ"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GE-GU"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GE-IM"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GE-KA"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GE-KK"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GE-MM"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GE-RL"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GE-SJ"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GE-SK"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GE-SZ"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GE-TB"), Tz::Asia_Tbilisi},
    {IsoCodes::subdivisionCodeToKey("GL-AV"), Tz::America_Nuuk},
    {IsoCodes::subdivisionCodeToKey("GL-AV"), Tz::America_Thule},
    {IsoCodes::subdivisionCodeToKey("GL-KU"), Tz::America_Nuuk},
    {IsoCodes::subdivisionCodeToKey("GL-QE"), Tz::America_Nuuk},
    {IsoCodes::subdivisionCodeToKey("GL-QT"), Tz::America_Nuuk},
    {IsoCodes::subdivisionCodeToKey("GL-SM"), Tz::America_Nuuk},
    {IsoCodes::subdivisionCodeToKey("GL-SM"), Tz::America_Scoresbysund},
    {IsoCodes::subdivisionCodeToKey("ID-AC"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-BA"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-BB"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-BE"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-BT"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-GO"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-JA"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-JB"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-JI"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-JK"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-JT"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-JW"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-KA"), Tz::Asia_Pontianak},
    {IsoCodes::subdivisionCodeToKey("ID-KA"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-KB"), Tz::Asia_Pontianak},
    {IsoCodes::subdivisionCodeToKey("ID-KI"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-KR"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-KS"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-KT"), Tz::Asia_Pontianak},
    {IsoCodes::subdivisionCodeToKey("ID-KU"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-LA"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-MA"), Tz::Asia_Jayapura},
    {IsoCodes::subdivisionCodeToKey("ID-ML"), Tz::Asia_Jayapura},
    {IsoCodes::subdivisionCodeToKey("ID-MU"), Tz::Asia_Jayapura},
    {IsoCodes::subdivisionCodeToKey("ID-NB"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-NT"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-NT"), Tz::Asia_Dili},
    {IsoCodes::subdivisionCodeToKey("ID-NU"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-NU"), Tz::Asia_Dili},
    {IsoCodes::subdivisionCodeToKey("ID-PA"), Tz::Asia_Jayapura},
    {IsoCodes::subdivisionCodeToKey("ID-PB"), Tz::Asia_Jayapura},
    {IsoCodes::subdivisionCodeToKey("ID-PP"), Tz::Asia_Jayapura},
    {IsoCodes::subdivisionCodeToKey("ID-RI"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-SA"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-SB"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-SG"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-SL"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-SM"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-SN"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-SR"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-SS"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-ST"), Tz::Asia_Makassar},
    {IsoCodes::subdivisionCodeToKey("ID-SU"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("ID-YO"), Tz::Asia_Jakarta},
    {IsoCodes::subdivisionCodeToKey("KI-G"), Tz::Pacific_Tarawa},
    {IsoCodes::subdivisionCodeToKey("KI-L"), Tz::Pacific_Kiritimati},
    {IsoCodes::subdivisionCodeToKey("KI-P"), Tz::Pacific_Enderbury},
    {IsoCodes::subdivisionCodeToKey("KZ-AKM"), Tz::Asia_Almaty},
    {IsoCodes::subdivisionCodeToKey("KZ-AKT"), Tz::Asia_Aqtobe},
    {IsoCodes::subdivisionCodeToKey("KZ-ALA"), Tz::Asia_Almaty},
    {IsoCodes::subdivisionCodeToKey("KZ-ALM"), Tz::Asia_Almaty},
    {IsoCodes::subdivisionCodeToKey("KZ-AST"), Tz::Asia_Almaty},
    {IsoCodes::subdivisionCodeToKey("KZ-ATY"), Tz::Asia_Atyrau},
    {IsoCodes::subdivisionCodeToKey("KZ-BAY"), Tz::Asia_Qyzylorda},
    {IsoCodes::subdivisionCodeToKey("KZ-KAR"), Tz::Asia_Almaty},
    {IsoCodes::subdivisionCodeToKey("KZ-KUS"), Tz::Asia_Qostanay},
    {IsoCodes::subdivisionCodeToKey("KZ-KZY"), Tz::Asia_Qyzylorda},
    {IsoCodes::subdivisionCodeToKey("KZ-MAN"), Tz::Asia_Aqtau},
    {IsoCodes::subdivisionCodeToKey("KZ-PAV"), Tz::Asia_Almaty},
    {IsoCodes::subdivisionCodeToKey("KZ-SEV"), Tz::Asia_Almaty},
    {IsoCodes::subdivisionCodeToKey("KZ-SHY"), Tz::Asia_Almaty},
    {IsoCodes::subdivisionCodeToKey("KZ-VOS"), Tz::Asia_Almaty},
    {IsoCodes::subdivisionCodeToKey("KZ-YUZ"), Tz::Asia_Almaty},
    {IsoCodes::subdivisionCodeToKey("KZ-ZAP"), Tz::Asia_Oral},
    {IsoCodes::subdivisionCodeToKey("KZ-ZHA"), Tz::Asia_Almaty},
    {IsoCodes::subdivisionCodeToKey("MA-01"), Tz::Africa_Casablanca},
    {IsoCodes::subdivisionCodeToKey("MA-02"), Tz::Africa_Casablanca},
    {IsoCodes::subdivisionCodeToKey("MA-03"), Tz::Africa_Casablanca},
    {IsoCodes::subdivisionCodeToKey("MA-04"), Tz::Africa_Casablanca},
    {IsoCodes::subdivisionCodeToKey("MA-05"), Tz::Africa_Casablanca},
    {IsoCodes::subdivisionCodeToKey("MA-06"), Tz::Africa_Casablanca},
    {IsoCodes::subdivisionCodeToKey("MA-07"), Tz::Africa_Casablanca},
    {IsoCodes::subdivisionCodeToKey("MA-08"), Tz::Africa_Casablanca},
    {IsoCodes::subdivisionCodeToKey("MA-09"), Tz::Africa_Casablanca},
    {IsoCodes::subdivisionCodeToKey("MA-10"), Tz::Africa_Casablanca},
    {IsoCodes::subdivisionCodeToKey("MA-10"), Tz::Africa_El_Aaiun},
    {IsoCodes::subdivisionCodeToKey("MA-11"), Tz::Africa_El_Aaiun},
    {IsoCodes::subdivisionCodeToKey("MA-11"), Tz::Africa_Casablanca},
    {IsoCodes::subdivisionCodeToKey("MA-12"), Tz::Africa_El_Aaiun},
    {IsoCodes::subdivisionCodeToKey("MH-L"), Tz::Pacific_Majuro},
    {IsoCodes::subdivisionCodeToKey("MH-L"), Tz::Pacific_Kwajalein},
    {IsoCodes::subdivisionCodeToKey("MH-T"), Tz::Pacific_Majuro},
    {IsoCodes::subdivisionCodeToKey("MN-035"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-037"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-039"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-041"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-043"), Tz::Asia_Hovd},
    {IsoCodes::subdivisionCodeToKey("MN-046"), Tz::Asia_Hovd},
    {IsoCodes::subdivisionCodeToKey("MN-047"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-049"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-051"), Tz::Asia_Choibalsan},
    {IsoCodes::subdivisionCodeToKey("MN-053"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-055"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-057"), Tz::Asia_Hovd},
    {IsoCodes::subdivisionCodeToKey("MN-059"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-061"), Tz::Asia_Choibalsan},
    {IsoCodes::subdivisionCodeToKey("MN-063"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-064"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-065"), Tz::Asia_Hovd},
    {IsoCodes::subdivisionCodeToKey("MN-067"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-069"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-071"), Tz::Asia_Hovd},
    {IsoCodes::subdivisionCodeToKey("MN-073"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MN-1"), Tz::Asia_Ulaanbaatar},
    {IsoCodes::subdivisionCodeToKey("MX-AGU"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-BCN"), Tz::America_Tijuana},
    {IsoCodes::subdivisionCodeToKey("MX-BCS"), Tz::America_Mazatlan},
    {IsoCodes::subdivisionCodeToKey("MX-CAM"), Tz::America_Merida},
    {IsoCodes::subdivisionCodeToKey("MX-CHH"), Tz::America_Chihuahua},
    {IsoCodes::subdivisionCodeToKey("MX-CHH"), Tz::America_Ojinaga},
    {IsoCodes::subdivisionCodeToKey("MX-CHP"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-CMX"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-COA"), Tz::America_Monterrey},
    {IsoCodes::subdivisionCodeToKey("MX-COA"), Tz::America_Matamoros},
    {IsoCodes::subdivisionCodeToKey("MX-COL"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-DUR"), Tz::America_Monterrey},
    {IsoCodes::subdivisionCodeToKey("MX-GRO"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-GUA"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-HID"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-JAL"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-MEX"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-MIC"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-MOR"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-NAY"), Tz::America_Mazatlan},
    {IsoCodes::subdivisionCodeToKey("MX-NAY"), Tz::America_Bahia_Banderas},
    {IsoCodes::subdivisionCodeToKey("MX-NLE"), Tz::America_Monterrey},
    {IsoCodes::subdivisionCodeToKey("MX-NLE"), Tz::America_Matamoros},
    {IsoCodes::subdivisionCodeToKey("MX-OAX"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-PUE"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-QUE"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-ROO"), Tz::America_Cancun},
    {IsoCodes::subdivisionCodeToKey("MX-SIN"), Tz::America_Mazatlan},
    {IsoCodes::subdivisionCodeToKey("MX-SLP"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-SON"), Tz::America_Hermosillo},
    {IsoCodes::subdivisionCodeToKey("MX-TAB"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-TAM"), Tz::America_Monterrey},
    {IsoCodes::subdivisionCodeToKey("MX-TAM"), Tz::America_Matamoros},
    {IsoCodes::subdivisionCodeToKey("MX-TLA"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-VER"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("MX-YUC"), Tz::America_Merida},
    {IsoCodes::subdivisionCodeToKey("MX-ZAC"), Tz::America_Mexico_City},
    {IsoCodes::subdivisionCodeToKey("NL-AW"), Tz::America_Aruba},
    {IsoCodes::subdivisionCodeToKey("NL-CW"), Tz::America_Curacao},
    {IsoCodes::subdivisionCodeToKey("NL-DR"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NL-FL"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NL-FR"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NL-GE"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NL-GR"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NL-LI"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NL-NB"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NL-NH"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NL-OV"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NL-SX"), Tz::America_Lower_Princes},
    {IsoCodes::subdivisionCodeToKey("NL-UT"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NL-ZE"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NL-ZH"), Tz::Europe_Amsterdam},
    {IsoCodes::subdivisionCodeToKey("NZ-AUK"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-BOP"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-CAN"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-CIT"), Tz::Pacific_Chatham},
    {IsoCodes::subdivisionCodeToKey("NZ-GIS"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-HKB"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-MBH"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-MWT"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-NSN"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-NTL"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-OTA"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-STL"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-TAS"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-TKI"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-WGN"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-WKO"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("NZ-WTC"), Tz::Pacific_Auckland},
    {IsoCodes::subdivisionCodeToKey("PG-CPK"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-CPM"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-EBR"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-EHG"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-EPW"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-ESW"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-GPK"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-HLA"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-JWK"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-MBA"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-MPL"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-MPM"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-MRL"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-NCD"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-NIK"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-NIK"), Tz::Pacific_Bougainville},
    {IsoCodes::subdivisionCodeToKey("PG-NPP"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-NSB"), Tz::Pacific_Bougainville},
    {IsoCodes::subdivisionCodeToKey("PG-SAN"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-SHM"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-WBK"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-WHM"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PG-WPD"), Tz::Pacific_Port_Moresby},
    {IsoCodes::subdivisionCodeToKey("PS-BTH"), Tz::Asia_Hebron},
    {IsoCodes::subdivisionCodeToKey("PS-BTH"), Tz::Asia_Jerusalem},
    {IsoCodes::subdivisionCodeToKey("PS-DEB"), Tz::Asia_Gaza},
    {IsoCodes::subdivisionCodeToKey("PS-GZA"), Tz::Asia_Gaza},
    {IsoCodes::subdivisionCodeToKey("PS-HBN"), Tz::Asia_Hebron},
    {IsoCodes::subdivisionCodeToKey("PS-HBN"), Tz::Asia_Jerusalem},
    {IsoCodes::subdivisionCodeToKey("PS-JEM"), Tz::Asia_Hebron},
    {IsoCodes::subdivisionCodeToKey("PS-JEM"), Tz::Asia_Jerusalem},
    {IsoCodes::subdivisionCodeToKey("PS-JEN"), Tz::Asia_Hebron},
    {IsoCodes::subdivisionCodeToKey("PS-JEN"), Tz::Asia_Jerusalem},
    {IsoCodes::subdivisionCodeToKey("PS-JRH"), Tz::Asia_Hebron},
    {IsoCodes::subdivisionCodeToKey("PS-JRH"), Tz::Asia_Jerusalem},
    {IsoCodes::subdivisionCodeToKey("PS-KYS"), Tz::Asia_Gaza},
    {IsoCodes::subdivisionCodeToKey("PS-NBS"), Tz::Asia_Hebron},
    {IsoCodes::subdivisionCodeToKey("PS-NBS"), Tz::Asia_Jerusalem},
    {IsoCodes::subdivisionCodeToKey("PS-NGZ"), Tz::Asia_Gaza},
    {IsoCodes::subdivisionCodeToKey("PS-QQA"), Tz::Asia_Hebron},
    {IsoCodes::subdivisionCodeToKey("PS-QQA"), Tz::Asia_Jerusalem},
    {IsoCodes::subdivisionCodeToKey("PS-RBH"), Tz::Asia_Hebron},
    {IsoCodes::subdivisionCodeToKey("PS-RBH"), Tz::Asia_Jerusalem},
    {IsoCodes::subdivisionCodeToKey("PS-RFH"), Tz::Asia_Gaza},
    {IsoCodes::subdivisionCodeToKey("PS-SLT"), Tz::Asia_Hebron},
    {IsoCodes::subdivisionCodeToKey("PS-SLT"), Tz::Asia_Jerusalem},
    {IsoCodes::subdivisionCodeToKey("PS-TBS"), Tz::Asia_Hebron},
    {IsoCodes::subdivisionCodeToKey("PS-TBS"), Tz::Asia_Jerusalem},
    {IsoCodes::subdivisionCodeToKey("PS-TKM"), Tz::Asia_Hebron},
    {IsoCodes::subdivisionCodeToKey("PS-TKM"), Tz::Asia_Jerusalem},
    {IsoCodes::subdivisionCodeToKey("PT-01"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-02"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-03"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-04"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-05"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-06"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-07"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-08"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-09"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-10"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-11"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-12"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-13"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-14"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-15"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-16"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-17"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-18"), Tz::Europe_Lisbon},
    {IsoCodes::subdivisionCodeToKey("PT-20"), Tz::Atlantic_Azores},
    {IsoCodes::subdivisionCodeToKey("PT-30"), Tz::Atlantic_Madeira},
    {IsoCodes::subdivisionCodeToKey("RU-AD"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-AL"), Tz::Asia_Barnaul},
    {IsoCodes::subdivisionCodeToKey("RU-ALT"), Tz::Asia_Barnaul},
    {IsoCodes::subdivisionCodeToKey("RU-AMU"), Tz::Asia_Yakutsk},
    {IsoCodes::subdivisionCodeToKey("RU-ARK"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-AST"), Tz::Europe_Astrakhan},
    {IsoCodes::subdivisionCodeToKey("RU-BA"), Tz::Asia_Yekaterinburg},
    {IsoCodes::subdivisionCodeToKey("RU-BEL"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-BRY"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-BU"), Tz::Asia_Irkutsk},
    {IsoCodes::subdivisionCodeToKey("RU-CE"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-CHE"), Tz::Asia_Yekaterinburg},
    {IsoCodes::subdivisionCodeToKey("RU-CHU"), Tz::Asia_Anadyr},
    {IsoCodes::subdivisionCodeToKey("RU-CU"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-DA"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-EAO"), Tz::Asia_Krasnoyarsk},
    {IsoCodes::subdivisionCodeToKey("RU-IN"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-IRK"), Tz::Asia_Irkutsk},
    {IsoCodes::subdivisionCodeToKey("RU-IVA"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-KAM"), Tz::Asia_Kamchatka},
    {IsoCodes::subdivisionCodeToKey("RU-KB"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-KC"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-KDA"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-KEM"), Tz::Asia_Novokuznetsk},
    {IsoCodes::subdivisionCodeToKey("RU-KGD"), Tz::Europe_Kaliningrad},
    {IsoCodes::subdivisionCodeToKey("RU-KGN"), Tz::Asia_Yekaterinburg},
    {IsoCodes::subdivisionCodeToKey("RU-KHA"), Tz::Asia_Vladivostok},
    {IsoCodes::subdivisionCodeToKey("RU-KHM"), Tz::Asia_Yekaterinburg},
    {IsoCodes::subdivisionCodeToKey("RU-KIR"), Tz::Europe_Kirov},
    {IsoCodes::subdivisionCodeToKey("RU-KK"), Tz::Asia_Krasnoyarsk},
    {IsoCodes::subdivisionCodeToKey("RU-KL"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-KLU"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-KO"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-KOS"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-KR"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-KRS"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-KYA"), Tz::Asia_Krasnoyarsk},
    {IsoCodes::subdivisionCodeToKey("RU-LEN"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-LIP"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-MAG"), Tz::Asia_Magadan},
    {IsoCodes::subdivisionCodeToKey("RU-ME"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-MO"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-MOS"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-MOW"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-MUR"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-NEN"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-NGR"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-NIZ"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-NVS"), Tz::Asia_Novosibirsk},
    {IsoCodes::subdivisionCodeToKey("RU-OMS"), Tz::Asia_Omsk},
    {IsoCodes::subdivisionCodeToKey("RU-ORE"), Tz::Asia_Yekaterinburg},
    {IsoCodes::subdivisionCodeToKey("RU-ORL"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-PER"), Tz::Asia_Yekaterinburg},
    {IsoCodes::subdivisionCodeToKey("RU-PNZ"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-PRI"), Tz::Asia_Vladivostok},
    {IsoCodes::subdivisionCodeToKey("RU-PSK"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-ROS"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-RYA"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-SA"), Tz::Asia_Yakutsk},
    {IsoCodes::subdivisionCodeToKey("RU-SA"), Tz::Asia_Srednekolymsk},
    {IsoCodes::subdivisionCodeToKey("RU-SA"), Tz::Asia_Vladivostok},
    {IsoCodes::subdivisionCodeToKey("RU-SA"), Tz::Asia_Khandyga},
    {IsoCodes::subdivisionCodeToKey("RU-SA"), Tz::Asia_Ust_Nera},
    {IsoCodes::subdivisionCodeToKey("RU-SAK"), Tz::Asia_Sakhalin},
    {IsoCodes::subdivisionCodeToKey("RU-SAK"), Tz::Asia_Ust_Nera},
    {IsoCodes::subdivisionCodeToKey("RU-SAK"), Tz::Asia_Srednekolymsk},
    {IsoCodes::subdivisionCodeToKey("RU-SAM"), Tz::Europe_Samara},
    {IsoCodes::subdivisionCodeToKey("RU-SAR"), Tz::Europe_Saratov},
    {IsoCodes::subdivisionCodeToKey("RU-SE"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-SMO"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-SPE"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-STA"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-SVE"), Tz::Asia_Yekaterinburg},
    {IsoCodes::subdivisionCodeToKey("RU-TA"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-TAM"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-TOM"), Tz::Asia_Tomsk},
    {IsoCodes::subdivisionCodeToKey("RU-TUL"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-TVE"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-TY"), Tz::Asia_Krasnoyarsk},
    {IsoCodes::subdivisionCodeToKey("RU-TYU"), Tz::Asia_Yekaterinburg},
    {IsoCodes::subdivisionCodeToKey("RU-UD"), Tz::Europe_Samara},
    {IsoCodes::subdivisionCodeToKey("RU-ULY"), Tz::Europe_Ulyanovsk},
    {IsoCodes::subdivisionCodeToKey("RU-VGG"), Tz::Europe_Volgograd},
    {IsoCodes::subdivisionCodeToKey("RU-VLA"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-VLG"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-VOR"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-YAN"), Tz::Asia_Yekaterinburg},
    {IsoCodes::subdivisionCodeToKey("RU-YAR"), Tz::Europe_Moscow},
    {IsoCodes::subdivisionCodeToKey("RU-YEV"), Tz::Asia_Vladivostok},
    {IsoCodes::subdivisionCodeToKey("RU-ZAB"), Tz::Asia_Chita},
    {IsoCodes::subdivisionCodeToKey("SD-DC"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-DE"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-DN"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-DS"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-DW"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-GD"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-GK"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-GK"), Tz::Africa_Juba},
    {IsoCodes::subdivisionCodeToKey("SD-GZ"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-KA"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-KH"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-KN"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-KS"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-NB"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-NO"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-NR"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-NW"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-RS"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SD-SI"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SS-BN"), Tz::Africa_Juba},
    {IsoCodes::subdivisionCodeToKey("SS-BW"), Tz::Africa_Juba},
    {IsoCodes::subdivisionCodeToKey("SS-BW"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("SS-EC"), Tz::Africa_Juba},
    {IsoCodes::subdivisionCodeToKey("SS-EE"), Tz::Africa_Juba},
    {IsoCodes::subdivisionCodeToKey("SS-EW"), Tz::Africa_Juba},
    {IsoCodes::subdivisionCodeToKey("SS-JG"), Tz::Africa_Juba},
    {IsoCodes::subdivisionCodeToKey("SS-LK"), Tz::Africa_Juba},
    {IsoCodes::subdivisionCodeToKey("SS-NU"), Tz::Africa_Juba},
    {IsoCodes::subdivisionCodeToKey("SS-UY"), Tz::Africa_Juba},
    {IsoCodes::subdivisionCodeToKey("SS-WR"), Tz::Africa_Juba},
    {IsoCodes::subdivisionCodeToKey("SS-WR"), Tz::Africa_Khartoum},
    {IsoCodes::subdivisionCodeToKey("UA-05"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-07"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-09"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-12"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-14"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-18"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-21"), Tz::Europe_Uzhgorod},
    {IsoCodes::subdivisionCodeToKey("UA-23"), Tz::Europe_Zaporozhye},
    {IsoCodes::subdivisionCodeToKey("UA-26"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-30"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-32"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-35"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-40"), Tz::Europe_Simferopol},
    {IsoCodes::subdivisionCodeToKey("UA-43"), Tz::Europe_Simferopol},
    {IsoCodes::subdivisionCodeToKey("UA-46"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-48"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-51"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-53"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-56"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-59"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-61"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-63"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-65"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-68"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-71"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-74"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UA-77"), Tz::Europe_Kiev},
    {IsoCodes::subdivisionCodeToKey("UM-67"), Tz::Pacific_Honolulu},
    {IsoCodes::subdivisionCodeToKey("UM-71"), Tz::Pacific_Midway},
    {IsoCodes::subdivisionCodeToKey("UM-76"), Tz::America_Port_au_Prince},
    {IsoCodes::subdivisionCodeToKey("UM-79"), Tz::Pacific_Wake},
    // UM-81
    // UM-84
    // UM-86
    // UM-89
    // UM-95
    {IsoCodes::subdivisionCodeToKey("US-AK"), Tz::America_Anchorage},
    {IsoCodes::subdivisionCodeToKey("US-AK"), Tz::America_Nome},
    {IsoCodes::subdivisionCodeToKey("US-AK"), Tz::America_Sitka},
    {IsoCodes::subdivisionCodeToKey("US-AK"), Tz::America_Adak},
    {IsoCodes::subdivisionCodeToKey("US-AK"), Tz::America_Juneau},
    {IsoCodes::subdivisionCodeToKey("US-AK"), Tz::America_Yakutat},
    {IsoCodes::subdivisionCodeToKey("US-AK"), Tz::America_Metlakatla},
    {IsoCodes::subdivisionCodeToKey("US-AL"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-AR"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-AS"), Tz::Pacific_Pago_Pago},
    {IsoCodes::subdivisionCodeToKey("US-AZ"), Tz::America_Phoenix},
    {IsoCodes::subdivisionCodeToKey("US-AZ"), Tz::America_Denver},
    {IsoCodes::subdivisionCodeToKey("US-CA"), Tz::America_Los_Angeles},
    {IsoCodes::subdivisionCodeToKey("US-CO"), Tz::America_Denver},
    {IsoCodes::subdivisionCodeToKey("US-CT"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-DC"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-DE"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-FL"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-FL"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-GA"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-GU"), Tz::Pacific_Guam},
    {IsoCodes::subdivisionCodeToKey("US-HI"), Tz::Pacific_Honolulu},
    {IsoCodes::subdivisionCodeToKey("US-HI"), Tz::Pacific_Midway},
    {IsoCodes::subdivisionCodeToKey("US-IA"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-ID"), Tz::America_Boise},
    {IsoCodes::subdivisionCodeToKey("US-ID"), Tz::America_Los_Angeles},
    {IsoCodes::subdivisionCodeToKey("US-IL"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-IN"), Tz::America_Indiana_Indianapolis},
    {IsoCodes::subdivisionCodeToKey("US-IN"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-IN"), Tz::America_Indiana_Vincennes},
    {IsoCodes::subdivisionCodeToKey("US-IN"), Tz::America_Kentucky_Louisville},
    {IsoCodes::subdivisionCodeToKey("US-IN"), Tz::America_Indiana_Winamac},
    {IsoCodes::subdivisionCodeToKey("US-IN"), Tz::America_Indiana_Tell_City},
    {IsoCodes::subdivisionCodeToKey("US-IN"), Tz::America_Indiana_Petersburg},
    {IsoCodes::subdivisionCodeToKey("US-IN"), Tz::America_Indiana_Knox},
    {IsoCodes::subdivisionCodeToKey("US-IN"), Tz::America_Indiana_Marengo},
    {IsoCodes::subdivisionCodeToKey("US-IN"), Tz::America_Indiana_Vevay},
    {IsoCodes::subdivisionCodeToKey("US-KS"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-KY"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-KY"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-KY"), Tz::America_Kentucky_Monticello},
    {IsoCodes::subdivisionCodeToKey("US-KY"), Tz::America_Kentucky_Louisville},
    {IsoCodes::subdivisionCodeToKey("US-LA"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-MA"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-MD"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-ME"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-MI"), Tz::America_Detroit},
    {IsoCodes::subdivisionCodeToKey("US-MI"), Tz::America_Menominee},
    {IsoCodes::subdivisionCodeToKey("US-MN"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-MO"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-MP"), Tz::Pacific_Saipan},
    {IsoCodes::subdivisionCodeToKey("US-MS"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-MT"), Tz::America_Denver},
    {IsoCodes::subdivisionCodeToKey("US-NC"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-ND"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-ND"), Tz::America_Denver},
    {IsoCodes::subdivisionCodeToKey("US-ND"), Tz::America_North_Dakota_New_Salem},
    {IsoCodes::subdivisionCodeToKey("US-ND"), Tz::America_North_Dakota_Beulah},
    {IsoCodes::subdivisionCodeToKey("US-ND"), Tz::America_North_Dakota_Center},
    {IsoCodes::subdivisionCodeToKey("US-NE"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-NE"), Tz::America_Denver},
    {IsoCodes::subdivisionCodeToKey("US-NH"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-NJ"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-NM"), Tz::America_Denver},
    {IsoCodes::subdivisionCodeToKey("US-NV"), Tz::America_Los_Angeles},
    {IsoCodes::subdivisionCodeToKey("US-NY"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-OH"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-OK"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-OR"), Tz::America_Los_Angeles},
    {IsoCodes::subdivisionCodeToKey("US-OR"), Tz::America_Boise},
    {IsoCodes::subdivisionCodeToKey("US-PA"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-PR"), Tz::America_Puerto_Rico},
    {IsoCodes::subdivisionCodeToKey("US-RI"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-SC"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-SD"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-SD"), Tz::America_Denver},
    {IsoCodes::subdivisionCodeToKey("US-TN"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-TN"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-TX"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-UM"), Tz::Pacific_Honolulu},
    {IsoCodes::subdivisionCodeToKey("US-UM"), Tz::Pacific_Midway},
    {IsoCodes::subdivisionCodeToKey("US-UM"), Tz::Pacific_Wake},
    {IsoCodes::subdivisionCodeToKey("US-UM"), Tz::America_Port_au_Prince},
    {IsoCodes::subdivisionCodeToKey("US-UT"), Tz::America_Denver},
    {IsoCodes::subdivisionCodeToKey("US-VA"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-VI"), Tz::America_St_Thomas},
    {IsoCodes::subdivisionCodeToKey("US-VT"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-WA"), Tz::America_Los_Angeles},
    {IsoCodes::subdivisionCodeToKey("US-WI"), Tz::America_Chicago},
    {IsoCodes::subdivisionCodeToKey("US-WV"), Tz::America_New_York},
    {IsoCodes::subdivisionCodeToKey("US-WY"), Tz::America_Denver},
    {IsoCodes::subdivisionCodeToKey("UZ-AN"), Tz::Asia_Tashkent},
    {IsoCodes::subdivisionCodeToKey("UZ-BU"), Tz::Asia_Samarkand},
    {IsoCodes::subdivisionCodeToKey("UZ-FA"), Tz::Asia_Tashkent},
    {IsoCodes::subdivisionCodeToKey("UZ-JI"), Tz::Asia_Tashkent},
    {IsoCodes::subdivisionCodeToKey("UZ-NG"), Tz::Asia_Tashkent},
    {IsoCodes::subdivisionCodeToKey("UZ-NW"), Tz::Asia_Samarkand},
    {IsoCodes::subdivisionCodeToKey("UZ-QA"), Tz::Asia_Samarkand},
    {IsoCodes::subdivisionCodeToKey("UZ-QR"), Tz::Asia_Samarkand},
    {IsoCodes::subdivisionCodeToKey("UZ-SA"), Tz::Asia_Samarkand},
    {IsoCodes::subdivisionCodeToKey("UZ-SI"), Tz::Asia_Tashkent},
    {IsoCodes::subdivisionCodeToKey("UZ-SU"), Tz::Asia_Samarkand},
    {IsoCodes::subdivisionCodeToKey("UZ-TK"), Tz::Asia_Tashkent},
    {IsoCodes::subdivisionCodeToKey("UZ-TO"), Tz::Asia_Tashkent},
    {IsoCodes::subdivisionCodeToKey("UZ-XO"), Tz::Asia_Samarkand},
    {IsoCodes::subdivisionCodeToKey("VN-01"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-02"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-03"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-04"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-05"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-06"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-07"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-09"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-13"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-14"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-18"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-20"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-21"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-22"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-23"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-24"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-25"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-26"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-27"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-28"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-29"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-30"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-31"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-32"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-33"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-34"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-35"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-36"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-37"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-39"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-40"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-41"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-43"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-44"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-45"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-46"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-47"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-49"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-50"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-51"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-52"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-53"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-54"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-55"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-56"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-57"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-58"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-59"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-61"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-63"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-66"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-67"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-68"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-69"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-70"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-71"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-72"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-73"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-CT"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-DN"), Tz::Asia_Ho_Chi_Minh},
    {IsoCodes::subdivisionCodeToKey("VN-HN"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-HP"), Tz::Asia_Bangkok},
    {IsoCodes::subdivisionCodeToKey("VN-SG"), Tz::Asia_Ho_Chi_Minh},
};
