/*
 * Copyright (C) 2019 Kai Uwe Broulik <kde@broulik.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) version 3, or any
 * later version accepted by the membership of KDE e.V. (or its
 * successor approved by the membership of KDE e.V.), which shall
 * act as a proxy defined in Section 6 of version 3 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BATTERYINTERFACE_H
#define BATTERYINTERFACE_H

#include "object.h"

#include <QDBusAbstractAdaptor>

class QDBusMessage;
class QDBusObjectPath;

class BatteryObject : public QObject
{
public:
    explicit BatteryObject(const QDBusObjectPath &path, QObject *parent = nullptr);
};

class BatteryInterface : public QDBusAbstractAdaptor, public Object
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.bluez.Battery1")
    Q_PROPERTY(uchar Percentage READ percentage)

public:
    explicit BatteryInterface(const QDBusObjectPath &path, const QVariantMap &properties, QObject *parent = nullptr);

    uchar percentage() const;
};

#endif // BATTERYINTERFACE_H
