/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "param.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "param_p.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>

/* code headers */

/* macro functions */
GWEN_LIST_FUNCTIONS(GWEN_PARAM, GWEN_Param)
GWEN_LIST2_FUNCTIONS(GWEN_PARAM, GWEN_Param)
GWEN_TREE_FUNCTIONS(GWEN_PARAM, GWEN_Param)


GWEN_PARAM_DATATYPE GWEN_Param_DataType_fromString(const char *p_s) {
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "int")==0)
      return GWEN_Param_DataType_Int;
    else if (strcasecmp(p_s, "bool")==0)
      return GWEN_Param_DataType_Bool;
    else if (strcasecmp(p_s, "float")==0)
      return GWEN_Param_DataType_Float;
    else if (strcasecmp(p_s, "string")==0)
      return GWEN_Param_DataType_String;
  }
  return GWEN_Param_DataType_Unknown;
}

GWEN_PARAM_TYPE GWEN_Param_Type_fromString(const char *p_s) {
  if (p_s && *p_s) {
    if (strcasecmp(p_s, "simple")==0)
      return GWEN_Param_Type_Simple;
    else if (strcasecmp(p_s, "choice")==0)
      return GWEN_Param_Type_Choice;
  }
  return GWEN_Param_Type_Unknown;
}

const char *GWEN_Param_DataType_toString(GWEN_PARAM_DATATYPE p_i) {
  switch(p_i) {
  case GWEN_Param_DataType_Int:
    return "int";
  case GWEN_Param_DataType_Bool:
    return "bool";
  case GWEN_Param_DataType_Float:
    return "float";
  case GWEN_Param_DataType_String:
    return "string";
  default:
    return "unknown";
  }
}

const char *GWEN_Param_Type_toString(GWEN_PARAM_TYPE p_i) {
  switch(p_i) {
  case GWEN_Param_Type_Simple:
    return "simple";
  case GWEN_Param_Type_Choice:
    return "choice";
  default:
    return "unknown";
  }
}

GWEN_PARAM *GWEN_Param_new(void) {
  GWEN_PARAM *p_struct;

  GWEN_NEW_OBJECT(GWEN_PARAM, p_struct)
  p_struct->_refCount=1;
  GWEN_LIST_INIT(GWEN_PARAM, p_struct)
  GWEN_TREE_INIT(GWEN_PARAM, p_struct)
  /* members */
  p_struct->name=NULL;
  p_struct->flags=0;
  p_struct->type=GWEN_Param_Type_Unknown;
  p_struct->dataType=GWEN_Param_DataType_Unknown;
  p_struct->shortDescription=NULL;
  p_struct->longDescription=NULL;
  p_struct->currentValue=NULL;
  p_struct->defaultValue=NULL;
  p_struct->choices=NULL;
  p_struct->internalIntValue=0;
  p_struct->internalFloatValue=0;
  p_struct->runtimeFlags=0;
  /* virtual functions */

  return p_struct;
}

void GWEN_Param_free(GWEN_PARAM *p_struct) {
  if (p_struct) {
    assert(p_struct->_refCount);
    if (p_struct->_refCount==1) {
      GWEN_LIST_FINI(GWEN_PARAM, p_struct)
      GWEN_TREE_FINI(GWEN_PARAM, p_struct)
      /* members */
      free(p_struct->name);
      free(p_struct->shortDescription);
      free(p_struct->longDescription);
      free(p_struct->currentValue);
      free(p_struct->defaultValue);
      GWEN_StringList2_free(p_struct->choices);
      p_struct->_refCount=0;
      GWEN_FREE_OBJECT(p_struct);
    }
    else
      p_struct->_refCount--;
  }
}

void GWEN_Param_Attach(GWEN_PARAM *p_struct) {
  assert(p_struct);
  assert(p_struct->_refCount);
  p_struct->_refCount++;
}

GWEN_PARAM *GWEN_Param_dup(const GWEN_PARAM *p_src) {
  GWEN_PARAM *p_struct;

  assert(p_src);
  p_struct=GWEN_Param_new();
  /* member "name" */
  if (p_struct->name) {
    free(p_struct->name);
    p_struct->name=NULL;
  }
  if (p_src->name) {
    p_struct->name=strdup(p_src->name);
  }

  /* member "flags" */
  p_struct->flags=p_src->flags;

  /* member "type" */
  p_struct->type=p_src->type;

  /* member "dataType" */
  p_struct->dataType=p_src->dataType;

  /* member "shortDescription" */
  if (p_struct->shortDescription) {
    free(p_struct->shortDescription);
    p_struct->shortDescription=NULL;
  }
  if (p_src->shortDescription) {
    p_struct->shortDescription=strdup(p_src->shortDescription);
  }

  /* member "longDescription" */
  if (p_struct->longDescription) {
    free(p_struct->longDescription);
    p_struct->longDescription=NULL;
  }
  if (p_src->longDescription) {
    p_struct->longDescription=strdup(p_src->longDescription);
  }

  /* member "currentValue" */
  if (p_struct->currentValue) {
    free(p_struct->currentValue);
    p_struct->currentValue=NULL;
  }
  if (p_src->currentValue) {
    p_struct->currentValue=strdup(p_src->currentValue);
  }

  /* member "defaultValue" */
  if (p_struct->defaultValue) {
    free(p_struct->defaultValue);
    p_struct->defaultValue=NULL;
  }
  if (p_src->defaultValue) {
    p_struct->defaultValue=strdup(p_src->defaultValue);
  }

  /* member "choices" */
  if (p_struct->choices) {
    GWEN_StringList2_free(p_struct->choices);
    p_struct->choices=NULL;
  }
  if (p_src->choices) {
    p_struct->choices=GWEN_StringList2_dup(p_src->choices);
  }

  /* member "internalIntValue" */
  p_struct->internalIntValue=p_src->internalIntValue;

  /* member "internalFloatValue" */
  p_struct->internalFloatValue=p_src->internalFloatValue;

  /* member "runtimeFlags" */
  p_struct->runtimeFlags=p_src->runtimeFlags;

  return p_struct;
}

GWEN_PARAM *GWEN_Param_copy(GWEN_PARAM *p_struct, const GWEN_PARAM *p_src) {
  assert(p_struct);
  assert(p_src);
  /* member "name" */
  if (p_struct->name) {
    free(p_struct->name);
    p_struct->name=NULL;
  }
  if (p_src->name) {
    p_struct->name=strdup(p_src->name);
  }

  /* member "flags" */
  p_struct->flags=p_src->flags;

  /* member "type" */
  p_struct->type=p_src->type;

  /* member "dataType" */
  p_struct->dataType=p_src->dataType;

  /* member "shortDescription" */
  if (p_struct->shortDescription) {
    free(p_struct->shortDescription);
    p_struct->shortDescription=NULL;
  }
  if (p_src->shortDescription) {
    p_struct->shortDescription=strdup(p_src->shortDescription);
  }

  /* member "longDescription" */
  if (p_struct->longDescription) {
    free(p_struct->longDescription);
    p_struct->longDescription=NULL;
  }
  if (p_src->longDescription) {
    p_struct->longDescription=strdup(p_src->longDescription);
  }

  /* member "currentValue" */
  if (p_struct->currentValue) {
    free(p_struct->currentValue);
    p_struct->currentValue=NULL;
  }
  if (p_src->currentValue) {
    p_struct->currentValue=strdup(p_src->currentValue);
  }

  /* member "defaultValue" */
  if (p_struct->defaultValue) {
    free(p_struct->defaultValue);
    p_struct->defaultValue=NULL;
  }
  if (p_src->defaultValue) {
    p_struct->defaultValue=strdup(p_src->defaultValue);
  }

  /* member "choices" */
  if (p_struct->choices) {
    GWEN_StringList2_free(p_struct->choices);
    p_struct->choices=NULL;
  }
  if (p_src->choices) {
    p_struct->choices=GWEN_StringList2_dup(p_src->choices);
  }

  /* member "internalIntValue" */
  p_struct->internalIntValue=p_src->internalIntValue;

  /* member "internalFloatValue" */
  p_struct->internalFloatValue=p_src->internalFloatValue;

  /* member "runtimeFlags" */
  p_struct->runtimeFlags=p_src->runtimeFlags;

  return p_struct;
}

const char *GWEN_Param_GetName(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->name;
}

uint32_t GWEN_Param_GetFlags(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->flags;
}

GWEN_PARAM_TYPE GWEN_Param_GetType(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->type;
}

GWEN_PARAM_DATATYPE GWEN_Param_GetDataType(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->dataType;
}

const char *GWEN_Param_GetShortDescription(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->shortDescription;
}

const char *GWEN_Param_GetLongDescription(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->longDescription;
}

const char *GWEN_Param_GetCurrentValue(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->currentValue;
}

const char *GWEN_Param_GetDefaultValue(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->defaultValue;
}

GWEN_STRINGLIST2 *GWEN_Param_GetChoices(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->choices;
}

int GWEN_Param_GetInternalIntValue(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->internalIntValue;
}

double GWEN_Param_GetInternalFloatValue(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->internalFloatValue;
}

uint32_t GWEN_Param_GetRuntimeFlags(const GWEN_PARAM *p_struct) {
  assert(p_struct);
  return p_struct->runtimeFlags;
}

void GWEN_Param_SetName(GWEN_PARAM *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->name) {
    free(p_struct->name);
  }
  if (p_src) {
    p_struct->name=strdup(p_src);
  }
  else {
    p_struct->name=NULL;
  }
}

void GWEN_Param_SetFlags(GWEN_PARAM *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->flags=p_src;
}

void GWEN_Param_AddFlags(GWEN_PARAM *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->flags|=p_src;
}

void GWEN_Param_SubFlags(GWEN_PARAM *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->flags&=~p_src;
}

void GWEN_Param_SetType(GWEN_PARAM *p_struct, GWEN_PARAM_TYPE  p_src) {
  assert(p_struct);
  p_struct->type=p_src;
}

void GWEN_Param_SetDataType(GWEN_PARAM *p_struct, GWEN_PARAM_DATATYPE  p_src) {
  assert(p_struct);
  p_struct->dataType=p_src;
}

void GWEN_Param_SetShortDescription(GWEN_PARAM *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->shortDescription) {
    free(p_struct->shortDescription);
  }
  if (p_src) {
    p_struct->shortDescription=strdup(p_src);
  }
  else {
    p_struct->shortDescription=NULL;
  }
}

void GWEN_Param_SetLongDescription(GWEN_PARAM *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->longDescription) {
    free(p_struct->longDescription);
  }
  if (p_src) {
    p_struct->longDescription=strdup(p_src);
  }
  else {
    p_struct->longDescription=NULL;
  }
}

void GWEN_Param_SetCurrentValue(GWEN_PARAM *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->currentValue) {
    free(p_struct->currentValue);
  }
  if (p_src) {
    p_struct->currentValue=strdup(p_src);
  }
  else {
    p_struct->currentValue=NULL;
  }
}

void GWEN_Param_SetDefaultValue(GWEN_PARAM *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->defaultValue) {
    free(p_struct->defaultValue);
  }
  if (p_src) {
    p_struct->defaultValue=strdup(p_src);
  }
  else {
    p_struct->defaultValue=NULL;
  }
}

void GWEN_Param_SetChoices(GWEN_PARAM *p_struct, GWEN_STRINGLIST2 *p_src) {
  assert(p_struct);
  if (p_struct->choices) {
    GWEN_StringList2_free(p_struct->choices);
  }
  p_struct->choices=p_src;
}

void GWEN_Param_SetInternalIntValue(GWEN_PARAM *p_struct, int p_src) {
  assert(p_struct);
  p_struct->internalIntValue=p_src;
}

void GWEN_Param_SetInternalFloatValue(GWEN_PARAM *p_struct, double p_src) {
  assert(p_struct);
  p_struct->internalFloatValue=p_src;
}

void GWEN_Param_SetRuntimeFlags(GWEN_PARAM *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags=p_src;
}

void GWEN_Param_AddRuntimeFlags(GWEN_PARAM *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags|=p_src;
}

void GWEN_Param_SubRuntimeFlags(GWEN_PARAM *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->runtimeFlags&=~p_src;
}

/* list1 functions */
GWEN_PARAM_LIST *GWEN_Param_List_dup(const GWEN_PARAM_LIST *p_src) {
  GWEN_PARAM_LIST *p_dest;
  GWEN_PARAM *p_elem;

  assert(p_src);
  p_dest=GWEN_Param_List_new();
  p_elem=GWEN_Param_List_First(p_src);
  while(p_elem) {
    GWEN_PARAM *p_cpy;

    p_cpy=GWEN_Param_dup(p_elem);
    GWEN_Param_List_Add(p_cpy, p_dest);
    p_elem=GWEN_Param_List_Next(p_elem);
  }

  return p_dest;
}

void GWEN_Param_ReadDb(GWEN_PARAM *p_struct, GWEN_DB_NODE *p_db) {
  assert(p_struct);
  /* member "name" */
  if (p_struct->name) {
    free(p_struct->name);
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "name", 0, NULL); if (s) p_struct->name=strdup(s); }
  if (p_struct->name==NULL) {
    p_struct->name=NULL;
  }

  /* member "flags" */
  p_struct->flags=GWEN_DB_GetIntValue(p_db, "flags", 0, 0);

  /* member "type" */
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "type", 0, NULL); if (s) p_struct->type=GWEN_Param_Type_fromString(s); else p_struct->type=GWEN_Param_Type_Unknown; }

  /* member "dataType" */
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "dataType", 0, NULL); if (s) p_struct->dataType=GWEN_Param_DataType_fromString(s); else p_struct->dataType=GWEN_Param_DataType_Unknown; }

  /* member "shortDescription" */
  if (p_struct->shortDescription) {
    free(p_struct->shortDescription);
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "shortDescription", 0, NULL); if (s) p_struct->shortDescription=strdup(s); }
  if (p_struct->shortDescription==NULL) {
    p_struct->shortDescription=NULL;
  }

  /* member "longDescription" */
  if (p_struct->longDescription) {
    free(p_struct->longDescription);
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "longDescription", 0, NULL); if (s) p_struct->longDescription=strdup(s); }
  if (p_struct->longDescription==NULL) {
    p_struct->longDescription=NULL;
  }

  /* member "currentValue" */
  if (p_struct->currentValue) {
    free(p_struct->currentValue);
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "currentValue", 0, NULL); if (s) p_struct->currentValue=strdup(s); }
  if (p_struct->currentValue==NULL) {
    p_struct->currentValue=NULL;
  }

  /* member "defaultValue" */
  if (p_struct->defaultValue) {
    free(p_struct->defaultValue);
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "defaultValue", 0, NULL); if (s) p_struct->defaultValue=strdup(s); }
  if (p_struct->defaultValue==NULL) {
    p_struct->defaultValue=NULL;
  }

  /* member "choices" */
  if (p_struct->choices) {
    GWEN_StringList2_free(p_struct->choices);
  }
  { p_struct->choices=GWEN_StringList2_fromDb(p_db, "choices", GWEN_StringList2_IntertMode_AlwaysAdd); }
  if (p_struct->choices==NULL) {
    p_struct->choices=NULL;
  }

  /* member "internalIntValue" */
  /* member "internalIntValue" is volatile, just presetting */
  p_struct->internalIntValue=0;

  /* member "internalFloatValue" */
  /* member "internalFloatValue" is volatile, just presetting */
  p_struct->internalFloatValue=0;

  /* member "runtimeFlags" */
  /* member "runtimeFlags" is volatile, just presetting */
  p_struct->runtimeFlags=0;

}

int GWEN_Param_WriteDb(const GWEN_PARAM *p_struct, GWEN_DB_NODE *p_db) {
  int p_rv;

  assert(p_struct);
  /* member "name" */
  if (p_struct->name) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "name", p_struct->name);
  else { GWEN_DB_DeleteVar(p_db, "name"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "flags" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "flags", p_struct->flags);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "type" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "type", GWEN_Param_Type_toString(p_struct->type));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "dataType" */
  p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "dataType", GWEN_Param_DataType_toString(p_struct->dataType));
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "shortDescription" */
  if (p_struct->shortDescription) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "shortDescription", p_struct->shortDescription);
  else { GWEN_DB_DeleteVar(p_db, "shortDescription"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "longDescription" */
  if (p_struct->longDescription) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "longDescription", p_struct->longDescription);
  else { GWEN_DB_DeleteVar(p_db, "longDescription"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "currentValue" */
  if (p_struct->currentValue) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "currentValue", p_struct->currentValue);
  else { GWEN_DB_DeleteVar(p_db, "currentValue"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "defaultValue" */
  if (p_struct->defaultValue) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "defaultValue", p_struct->defaultValue);
  else { GWEN_DB_DeleteVar(p_db, "defaultValue"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "choices" */
  if (p_struct->choices) { p_rv=GWEN_StringList2_toDb(p_struct->choices, p_db, "choices"); }
  else { GWEN_DB_DeleteVar(p_db, "choices"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "internalIntValue" is volatile, not writing to db */

  /* member "internalFloatValue" is volatile, not writing to db */

  /* member "runtimeFlags" is volatile, not writing to db */

  return 0;
}

GWEN_PARAM *GWEN_Param_fromDb(GWEN_DB_NODE *p_db) {
  GWEN_PARAM *p_struct;
  p_struct=GWEN_Param_new();
  GWEN_Param_ReadDb(p_struct, p_db);
  return p_struct;
}

int GWEN_Param_toDb(const GWEN_PARAM *p_struct, GWEN_DB_NODE *p_db) {
  return GWEN_Param_WriteDb(p_struct, p_db);
}

void GWEN_Param_ReadXml(GWEN_PARAM *p_struct, GWEN_XMLNODE *p_db) {
  assert(p_struct);
  /* member "name" */
  if (p_struct->name) {
    free(p_struct->name);
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "name", NULL); if (s) p_struct->name=strdup(s); }
  if (p_struct->name==NULL) {  /* member "name" is volatile, just presetting */
    p_struct->name=NULL;
  }

  /* member "flags" */
  p_struct->flags=GWEN_XMLNode_GetIntValue(p_db, "flags", 0);

  /* member "type" */
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "type", NULL); if (s) p_struct->type=GWEN_Param_Type_fromString(s); else p_struct->type=GWEN_Param_Type_Unknown; }

  /* member "dataType" */
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "dataType", NULL); if (s) p_struct->dataType=GWEN_Param_DataType_fromString(s); else p_struct->dataType=GWEN_Param_DataType_Unknown; }

  /* member "shortDescription" */
  if (p_struct->shortDescription) {
    free(p_struct->shortDescription);
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "shortDescription", NULL); if (s) p_struct->shortDescription=strdup(s); }
  if (p_struct->shortDescription==NULL) {  /* member "shortDescription" is volatile, just presetting */
    p_struct->shortDescription=NULL;
  }

  /* member "longDescription" */
  if (p_struct->longDescription) {
    free(p_struct->longDescription);
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "longDescription", NULL); if (s) p_struct->longDescription=strdup(s); }
  if (p_struct->longDescription==NULL) {  /* member "longDescription" is volatile, just presetting */
    p_struct->longDescription=NULL;
  }

  /* member "currentValue" */
  if (p_struct->currentValue) {
    free(p_struct->currentValue);
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "currentValue", NULL); if (s) p_struct->currentValue=strdup(s); }
  if (p_struct->currentValue==NULL) {  /* member "currentValue" is volatile, just presetting */
    p_struct->currentValue=NULL;
  }

  /* member "defaultValue" */
  if (p_struct->defaultValue) {
    free(p_struct->defaultValue);
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "defaultValue", NULL); if (s) p_struct->defaultValue=strdup(s); }
  if (p_struct->defaultValue==NULL) {  /* member "defaultValue" is volatile, just presetting */
    p_struct->defaultValue=NULL;
  }

  /* member "choices" */
  if (p_struct->choices) {
    GWEN_StringList2_free(p_struct->choices);
  }
  { GWEN_XMLNODE *n; n=GWEN_XMLNode_FindFirstTag(p_db, "choices", 0, 0); if(n) { p_struct->choices=GWEN_StringList2_fromXml(n, GWEN_StringList2_IntertMode_AlwaysAdd); } else p_struct->choices=NULL; }
  if (p_struct->choices==NULL) {  /* member "choices" is volatile, just presetting */
    p_struct->choices=NULL;
  }

  /* member "internalIntValue" */
  /* member "internalIntValue" is volatile, just presetting */
  p_struct->internalIntValue=0;

  /* member "internalFloatValue" */
  /* member "internalFloatValue" is volatile, just presetting */
  p_struct->internalFloatValue=0;

  /* member "runtimeFlags" */
  /* member "runtimeFlags" is volatile, just presetting */
  p_struct->runtimeFlags=0;

}

void GWEN_Param_WriteXml(const GWEN_PARAM *p_struct, GWEN_XMLNODE *p_db) {
  assert(p_struct);
  /* member "name" */
  GWEN_XMLNode_SetCharValue(p_db, "name", p_struct->name);

  /* member "flags" */
  GWEN_XMLNode_SetIntValue(p_db, "flags", p_struct->flags);

  /* member "type" */
  GWEN_XMLNode_SetCharValue(p_db, "type", GWEN_Param_Type_toString(p_struct->type));

  /* member "dataType" */
  GWEN_XMLNode_SetCharValue(p_db, "dataType", GWEN_Param_DataType_toString(p_struct->dataType));

  /* member "shortDescription" */
  GWEN_XMLNode_SetCharValue(p_db, "shortDescription", p_struct->shortDescription);

  /* member "longDescription" */
  GWEN_XMLNode_SetCharValue(p_db, "longDescription", p_struct->longDescription);

  /* member "currentValue" */
  GWEN_XMLNode_SetCharValue(p_db, "currentValue", p_struct->currentValue);

  /* member "defaultValue" */
  GWEN_XMLNode_SetCharValue(p_db, "defaultValue", p_struct->defaultValue);

  /* member "choices" */
  if (p_struct->choices) { GWEN_XMLNODE *n; n=GWEN_XMLNode_new(GWEN_XMLNodeTypeTag, "choices"); GWEN_StringList2_toXml(p_struct->choices, n); GWEN_XMLNode_AddChild(p_db, n); }

  /* member "internalIntValue" is volatile, not writing to xml */

  /* member "internalFloatValue" is volatile, not writing to xml */

  /* member "runtimeFlags" is volatile, not writing to xml */

}

void GWEN_Param_toXml(const GWEN_PARAM *p_struct, GWEN_XMLNODE *p_db) {
  GWEN_Param_WriteXml(p_struct, p_db);
}

GWEN_PARAM *GWEN_Param_fromXml(GWEN_XMLNODE *p_db) {
  GWEN_PARAM *p_struct;
  p_struct=GWEN_Param_new();
  GWEN_Param_ReadXml(p_struct, p_db);
  return p_struct;
}

GWEN_PARAM *GWEN_Param_List_GetByName(const GWEN_PARAM_LIST *p_list,  const char *p_cmp) {
  GWEN_PARAM *p_struct;

  assert(p_list);
  p_struct = GWEN_Param_List_First(p_list);
  while(p_struct) {
    int p_rv;

    if (p_struct->name && p_cmp) p_rv=strcasecmp(p_cmp, p_struct->name);
    else if (p_cmp) p_rv=1;
    else if (p_struct->name) p_rv=-1;
    else p_rv=0;
    if (p_rv == 0)
      return p_struct;
    p_struct = GWEN_Param_List_Next(p_struct);
  }
  return NULL;
}

GWEN_PARAM *GWEN_Param_Tree_GetByName(const GWEN_PARAM_TREE *p_tree,  const char *p_cmp) {
  GWEN_PARAM *p_struct;

  assert(p_tree);
  p_struct = GWEN_Param_Tree_GetFirst(p_tree);
  while(p_struct) {
    int p_rv;

    if (p_struct->name && p_cmp) p_rv=strcasecmp(p_cmp, p_struct->name);
    else if (p_cmp) p_rv=1;
    else if (p_struct->name) p_rv=-1;
    else p_rv=0;
    if (p_rv == 0)
      return p_struct;
    p_struct = GWEN_Param_Tree_GetBelow(p_struct);
  }
  return NULL;
}


/* code headers */
#include "param_fns.c"

