/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "functiongroupitempopup.h"
#include "functiongrouplistviewitem.h"

	/**
	 * Constructor
	 */
	FunctionGroupItemPopup::FunctionGroupItemPopup(QWidget *pqoParent, FunctionGroupListViewItem *poFunctionGroupItem)
		: QPopupMenu(pqoParent)
	{
		m_poFunctionGroupItem = poFunctionGroupItem;	// keep a reference to the Function group item
		
		// setup all the items and their slots
		//insertSeparator();
		insertItem("Refresh", this, SLOT(refreshListOfFunctions()));		
	} // end constructor

	/**
	 * Used to access the Function group list view item.
	 */
	FunctionGroupListViewItem * FunctionGroupItemPopup::getFunctionGroupListViewItem() const
	{
		return m_poFunctionGroupItem;
	} // end getViewGroupListViewItem
	
	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the view list.
   */	
	void FunctionGroupItemPopup::refreshListOfFunctions()
	{
		// lets refresh the list as requested
		m_poFunctionGroupItem->refreshList();
	} // end refreshListOfFunctions
