/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef FUNCTIONGROUPLISTVIEWITEM_H
#define FUNCTIONGROUPLISTVIEWITEM_H

#include "../baselistviewitem.h"
#include "../../dataaccess/dbmastermanagerref.h"

/**
 * This list view item is used to represent a group of database functions.
 */
class FunctionGroupListViewItem: public BaseListViewItem, public DBMasterManagerRef
{

public:
	
	/**
 	 * Constructor
   */		
	FunctionGroupListViewItem(QListViewItem *pqoListViewItem);
	FunctionGroupListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);
			
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	virtual void initChildren();
		
protected:

};


#endif

