/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "indexgroupitempopup.h"
#include "indexgrouplistviewitem.h"

	/**
	 * Constructor
	 */
	IndexGroupItemPopup::IndexGroupItemPopup(QWidget *pqoParent, IndexGroupListViewItem *poIndexGroupItem)
		: QPopupMenu(pqoParent)
	{
		m_poIndexGroupItem = poIndexGroupItem;	// keep a reference to the Index group item
		
		// setup all the items and their slots
		//insertSeparator();
		insertItem("Refresh", this, SLOT(refreshListOfIndicies()));		
	} // end constructor

	/**
	 * Used to access the Index group list view item.
	 */
	IndexGroupListViewItem * IndexGroupItemPopup::getIndexGroupListViewItem() const
	{
		return m_poIndexGroupItem;
	} // end getViewGroupListViewItem
	
	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the view list.
   */	
	void IndexGroupItemPopup::refreshListOfIndicies()
	{
		// lets refresh the list as requested
		m_poIndexGroupItem->refreshList();
	} // end refreshListOfIndicies
